<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
// Lógica primero para evitar errores de Header
require_once '../config/db.php';

$id = $_GET['id'] ?? null;
if (!$id) { header("Location: asesores.php"); exit; }

$stmt = $pdo->prepare("SELECT * FROM team_members WHERE id = ?");
$stmt->execute([$id]);
$a = $stmt->fetch(PDO::FETCH_ASSOC);

// Función slug reutilizada
function limpiarNombre($string) {
    $string = trim($string);
    $string = str_replace(array('á','à','ä','â','ª','Á','À','Â','Ä'), array('a','a','a','a','a','A','A','A','A'), $string);
    $string = str_replace(array('é','è','ë','ê','É','È','Ê','Ë'), array('e','e','e','e','E','E','E','E'), $string);
    $string = str_replace(array('í','ì','ï','î','Í','Ì','Ï','Î'), array('i','i','i','i','I','I','I','I'), $string);
    $string = str_replace(array('ó','ò','ö','ô','Ó','Ò','Ö','Ô'), array('o','o','o','o','O','O','O','O'), $string);
    $string = str_replace(array('ú','ù','ü','û','Ú','Ù','Û','Ü'), array('u','u','u','u','U','U','U','U'), $string);
    $string = str_replace(array('ñ','Ñ','ç','Ç'), array('n','N','c','C'), $string);
    $string = preg_replace('/[^a-zA-Z0-9-]/', '-', $string);
    $string = strtolower($string);
    return $string;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = $_POST['full_name'];
    $position  = $_POST['position'];
    $whatsapp  = $_POST['whatsapp'];
    $email     = $_POST['email'];
    
    $new_slug = limpiarNombre($full_name);
    $photo_url = $a['photo_url']; 
    $base_dir = "../public/img/asesores/";

    // CASO 1: SUBE NUEVA FOTO
    if (!empty($_FILES['photo']['name'])) {
        $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $new_filename = $new_slug . "." . $ext;

        if (file_exists($base_dir . $new_filename) && $new_filename != $photo_url) {
            $new_filename = $new_slug . "-" . time() . "." . $ext;
        }

        if (move_uploaded_file($_FILES['photo']['tmp_name'], $base_dir . $new_filename)) {
            if ($photo_url && $photo_url != 'default_avatar.jpg' && file_exists($base_dir . $photo_url)) {
                unlink($base_dir . $photo_url);
            }
            $photo_url = $new_filename;
        }
    } 
    // CASO 2: SOLO CAMBIA NOMBRE -> RENOMBRAR ARCHIVO
    elseif ($photo_url && $photo_url != 'default_avatar.jpg' && file_exists($base_dir . $photo_url)) {
        $current_ext = pathinfo($photo_url, PATHINFO_EXTENSION);
        $potential_new_name = $new_slug . "." . $current_ext;
        
        if ($photo_url !== $potential_new_name) {
             if (!file_exists($base_dir . $potential_new_name)) {
                 rename($base_dir . $photo_url, $base_dir . $potential_new_name);
                 $photo_url = $potential_new_name;
             } else {
                 $potential_new_name = $new_slug . "-" . $id . "." . $current_ext;
                 rename($base_dir . $photo_url, $base_dir . $potential_new_name);
                 $photo_url = $potential_new_name;
             }
        }
    }

    $sql = "UPDATE team_members SET full_name=?, position=?, whatsapp=?, email=?, photo_url=? WHERE id=?";
    $pdo->prepare($sql)->execute([$full_name, $position, $whatsapp, $email, $photo_url, $id]);
    
    header("Location: asesores.php?status=updated");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
?>

<main class="flex-1 p-8">
    <div class="max-w-3xl mx-auto">
        <div class="flex items-center gap-4 mb-8">
            <a href="asesores.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-colors shadow-sm">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <h1 class="font-display font-black text-3xl dark:text-white uppercase">Editar Asesor</h1>
        </div>

        <form method="POST" enctype="multipart/form-data" class="bg-white dark:bg-brand-dark p-8 rounded-xl border border-gray-100 dark:border-white/5 space-y-6 shadow-xl">
            
            <div class="flex justify-center mb-6">
                <label for="photoInput" class="relative group cursor-pointer">
                    <div class="w-32 h-32 rounded-full overflow-hidden border-4 border-gray-100 dark:border-white/10 shadow-lg bg-gray-50 dark:bg-black/20 flex items-center justify-center">
                        <?php 
                            $currentImg = ($a['photo_url'] && $a['photo_url'] != 'default_avatar.jpg') 
                                ? "../public/img/asesores/" . $a['photo_url'] 
                                : "../public/img/default_avatar.jpg";
                        ?>
                        <img id="preview" src="<?php echo $currentImg; ?>" class="w-full h-full object-cover">
                        
                        <div class="absolute inset-0 bg-black/30 opacity-0 group-hover:opacity-100 flex flex-col items-center justify-center text-white transition-all z-10">
                            <i class="ri-camera-switch-line text-3xl"></i>
                        </div>
                    </div>
                    <input id="photoInput" type="file" name="photo" class="hidden" accept="image/*" onchange="showPreview(event)">
                </label>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Nombre Completo</label>
                    <input type="text" name="full_name" value="<?php echo htmlspecialchars($a['full_name']); ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Cargo</label>
                    <input type="text" name="position" value="<?php echo htmlspecialchars($a['position']); ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">WhatsApp</label>
                    <input type="text" name="whatsapp" value="<?php echo htmlspecialchars($a['whatsapp']); ?>" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Email</label>
                    <input type="email" name="email" value="<?php echo htmlspecialchars($a['email']); ?>" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none transition-all">
                </div>
            </div>

            <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-bold uppercase py-4 rounded-xl shadow-lg transition-all transform active:scale-95">
                Guardar Cambios
            </button>
        </form>
    </div>
</main>

<script>
function showPreview(event) {
    const input = event.target;
    const preview = document.getElementById('preview');
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

<?php require_once 'includes/footer.php'; ?>